Attribute VB_Name = "SketchChecker"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999-2001 Parametric Technology Corporation.
'	All rights reserved.

Option Explicit

Public SketchCheckerDialogReturn As Integer

Sub SketchChecker()
	Dim pdApp As ProDESKTOP
	Set pdApp = CreateObject("ProDESKTOP.Application")

	Dim doc As GraphicDocument
	Set doc = pdApp.GetActiveDoc

	If doc Is Nothing then
		Exit Sub
	End If

	If TypeOf doc Is PartDocument Then
		Dim des As aDesign
		Set des = doc.GetDesign

		Dim wp1 As aWorkplane
		Set wp1 = doc.GetActiveWorkplane

		Dim sk As aSketch
		Set sk = doc.GetActiveSketch

		Dim lineSet As ObjectSet
		Set lineSet = doc.GetSelection("Line")

		If lineSet.IsEmpty Then
			MsgBox "Nothing selected. Selecting the lines of the active sketch.", vbExclamation
			Set lineSet = sk.GetLines(True, True)
		End If

		doc.ClearSelection
		doc.Update 3

		MsgBox lineSet.GetCount & " Lines found"

		Dim it As Iterator
		Set it = pdApp.GetClass("It").CreateAObjectIt(lineSet)

		Dim lineObject As ObjectSet
		Set lineObject = pdApp.GetClass("ObjectSet").CreateAObjectSet

		Dim result As Integer

		it.start

		Do While it.IsActive
			If Not lineObject.IsEmpty Then
				lineObject.RemoveAll
				doc.ClearSelection
				doc.Update 3
			End If

			lineObject.AddMember it.Current
			doc.AddToSelection lineObject
			doc.Update 3

			frmSketchChecker.Show

			If SketchCheckerDialogReturn = 1 Then 'vbYes Then  'for msgbox, and use result as above
				Exit Do
			ElseIf SketchCheckerDialogReturn = 2 Then 'vbCancel Then  'for msgbox and use result
				doc.ClearSelection
				doc.Update 3
				Exit Sub
			ElseIf SketchCheckerDialogReturn = 3 Then 'Delete the selected line
				it.Current.Delete
				doc.Update 1
				it.Next
			Else 'must be vbNo go round again !!
				it.Next
			End If
		Loop
	End If
End Sub
